//----------------------------------------------------------------------------//
//- CaoFormat.pas ------------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Diese Klasse dient zum Formatieren von Strings                             //
//----------------------------------------------------------------------------//

unit CaoFormat;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

//------------------------------------------------------------------------------

type
  TCaoFormat = class (TObject)

  //----------------------------------------------------------------------------

  public
    function FormatCurrency(dValue : Double) : string;
    function FormatBarCode(iNumber: Integer): string;

  //----------------------------------------------------------------------------

  end; // TCaoFormat

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

function TCaoFormat.FormatBarCode(iNumber: Integer): string;
(*
  Am Anfang und am Ende des Strichcode-Strings die Strichcodekennung einfgen
*)
begin
  Result := '*' + FormatFloat('000000', iNumber) + '*';
end; // TCaoFormat.FormatBareCode

//------------------------------------------------------------------------------

function TCaoFormat.FormatCurrency(dValue: Double): string;
begin
  Result := FormatFloat('0.00', dValue);
end; // TCaoFormat.FormatCurrency

//------------------------------------------------------------------------------

end. // CaoFormat
